<%@ Page Language="c#" Debug="true" Codebehind="MastAppHelp.pas" AutoEventWireup="false" Inherits="MastAppHelp.TWebForm1"%>
<%@ Register tagprefix="uc1" tagname="MastAppMenu" Src="MastAppMenu.ascx"%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">

<html>
  <head>
    <title>MastApp Demo - Help</title>
    <link href="mastapp.css" type="text/css" rel="stylesheet">
  </head>
  <body style="HEIGHT: 375px" ms_positioning="GridLayout">
    <form runat="server">
      <h1>
        <uc1:MastAppMenu id="UserControl1" runat="server"></uc1:MastAppMenu>
      </h1>
      <h1>MastApp Help Contents</h1>
      <p>&nbsp;</p>
      <p>This is a sample application that demonstrates&nbsp;using
      ASP.NET in Delphi, BDP.NET and DBWeb capabilities. Click on a link below
      to learn more about the functionalities of this application.</p>
      <p>Note: Help for each button describes the button's purpose in
      the application, lists the MastApp project files used to build that part
      of the application and details significant features of the product that
      the button illustrates.</p>
      <p><a href="MastAppHelp.aspx#setup">Application
        Setup</a>
      </p>
      <p><a href="MastAppHelp.aspx#mastappmenu">MastApp
        Menu</a>
      </p>
      <p><a href="MastAppHelp.aspx#browseorders">Browse
        Orders</a>
      </p>
      <p><a href="MastAppHelp.aspx#browseparts">Browse
        Parts</a>
      </p>
      <p><a href="MastAppHelp.aspx#updateorders">Update
        Orders</a>
      </p>
      <p><a href="MastAppHelp.aspx#updateitems">Update
        Items</a>
      </p>
      <p><a href="MastAppHelp.aspx#querycustomer">Query
        Customer</a>
      </p>
      <p><a href="#mastapphelp">MastApp Help</a>
      </p>
      <p><a href="MastAppHelp.aspx#mastappcss">MastApp
        StyleSheet</a>
      </p>
      <p><a href="#global">Global.pas</a>
      </p>
      <p>&nbsp;</p>
      <h3 id="setup">Application Setup </h3>
      <p>Please read the instructions in <a href="readme.htm">readme.htm</a>
       to learn about application setup. readme.htm includes links to <a href="ASPSetup.htm">ASPSetup.htm</a>
       and <a href="DBSetup.htm">DBSetup.htm</a>
      </p>
      <p>&nbsp;</p>
      <h3 id="mastappmenu">MastApp Menu </h3>
      <p>This menu has a list of buttons you see at the top of every
      aspx page. This menu demonstrates how you can use an ASP.NET User Control
      in a web application. The menu buttons are contained in this ASP.NET user
      control which is in a separate .ascx file. This user control&nbsp;is
      attached to the web page using the Register directive as follows:</p>
      <p>&lt;%@ Register tagprefix="uc1" tagname="MastAppMenu"
      Src="MastAppMenu.ascx"%&gt;</p>
      <p>Source Code for this user control can be found in:</p>
      <ul>
        <li>MastAppMenu.ascx 
        <li>MastAppMenu.pas </li>
      </ul>
      <p>&nbsp;</p>
      <h3 id="browseorders">Browse Orders </h3>
      <p>To examine the orders placed by customers, click the Browse
      Orders button.</p>
      <p>The top grid in this page displays all MAST customers. The
      first customer number in the CUSTOMER table is always selected by default.
      The bottom grid displays all orders&nbsp;associated with the selected
      customer. You can scroll to different records in CUSTOMER grid using the
      navigator or&nbsp;the Select link&nbsp;on each
      record&nbsp;and&nbsp;also&nbsp;by clicking on the desired page number on
      the grid.</p>
      <p>You can filter customers based on a given date range which is
      done through the "Define Query" button and "Activate Query" checkbox.
      Define Query button invokes the <a href="#querycustomer">QueryCustomer</a>
       web page where you can enter a narrower range of dates against
      which to check for customer invoices. Once the query is defined, you can
      then check the Activate Query checkbox to display customers that are in
      the specified date range. All customer records will be displayed when the
      query is deactivated by unchecking the 'Activate Query' checkbox. 
      </p>
      <p>This page demonstrates how to setup master-detail relationship
      in a database application using ASP.NET. This page uses two DBWebGrid
      controls and a DBWebNavigator to navigate through rows in
      the&nbsp;customer grid. BDPDataAdapter components are used to populate the
      data retrieved from the database tables into the dataset. The MaxRecords
      property for the DataAdapter components are initially set to 10000 but
      this can be changed if there are more records. Master-detail relationship
      is created dynamically in the code&nbsp;since the SQL query for the
      BdpDataAdapter component changes&nbsp;when ActivateQuery checkbox is
      turned on or off.</p>
      <p>Source code for this page can be found in:</p>
      <ul>
        <li>BrowseOrders.aspx 
        <li>BrowseOrders.pas </li>
      </ul>
      <p>&nbsp;</p>
      <h3 id="browseparts">Browse Parts </h3>
      <p>This web page enables you to browse and edit the MAST Parts
      inventory.</p>
      <p>This web page contains a System.Web.UI.WebControls.DataGrid
      component to display the records from PARTS table and a "Back Order"
      checkbox to query and display only the parts on back order. Each record
      has an Edit hyperlink to make changes to the part description and vendor.
      You can either choose to update th part after making changes using the
      Update hyperlink for the selected record or cancel the changes by using
      the Cancel hyperlink.</p>
      <p>Updating a database from a web application is tricky but the
      built-in support provided in Datagrid control makes this easier. Using
      datagrid's EditItemTemplate is demonstrated in this page. EditCommand,
      UpdateCommand and CancelCommand events are used to edit, update and cancel
      the changes to the selected record.</p>
      <p>This page also demonstrates how a query for the BdpDataAdapter
      component can be changed at run-time. The MaxRecords property for the
      Vendors and Parts DataAdapter components are initially set to 10000 but
      this can be changed if there are more records.</p>
      <p>Source code for this web page can be found in:</p>
      <ul>
        <li>BrowseParts.aspx 
        <li>BrowseParts.pas </li>
      </ul>
      <p>&nbsp;</p>
      <h3 id="updateorders">Update Orders </h3>
      <p>This web page enables you to enter new customer orders, modify
      existing customer orders and browse existing orders.</p>
      <p>This form contains a DBWebNavigator component to navigate
      through the ORDERS table and DBWeb data aware controls to display data.
      There is a link at the bottom titled "Update Items Cart" which will show
      all the PARTS that has been ordered for the selected order number. After
      you enter a new order, you can use the "Update Items Cart" link to go to
      the <a href="#updateitems">UpdateItems</a>
       page to add PARTS that you would like to order. 
      </p>
      <p>This page demonstrates the following.</p>
      <ul>
        <li>It uses RequiredFieldValidator controls and a
        ValidationSummary control to validate and display if the required fields
        are left blank 
        <li>It creates a custom&nbsp;column in the EMPLOYEE table to
        display the full name of the employee in the "Sold By" field 
        <li>It uses DBWebDropDownList to display look-up fields 
        <li>It uses DBWebDataSource component's GetPostCollection
        event to enable the form to automatically increment and use the next
        available ORDERNO which is the primary key for the ORDERS table </li>
      </ul>
      <p>Source code for this web page can be found in:</p>
      <ul>
        <li>UpdateOrders.pas 
        <li>UpdateOrders.aspx </li>
      </ul>
      <p>&nbsp;</p>
      <h3 id="updateitems">Update Items</h3>
      <p>This page demonstrates a lot of features. You can use this page
      to add PART items to a new order that was created using the <a href="#updateorders">UpdateOrders</a>
       page or to view or delete PART items of an existing order. 
      </p>
      <p>This page demonstrates the following:</p>
      <ul>
        <li>It shows how validator controls can be used for
        validation. It uses RequiredFieldValidator, CompareValidator&nbsp;and
        RangeValidator for&nbsp;Part Description listbox, Quantity and Discount
        values respectively. It also has a ValidationSummary control to display
        the&nbsp;result if validation of one of these fields fail 
        <li>It uses&nbsp;an&nbsp;ASP Button control in the datagrid's
        ItemTemplate and DeleteCommand DataGrid event to enable you to delete
        items from the grid 
        <li>It uses TextBox controls in the footer using
        FooterTemplate to show the calculated price, amount already paid and
        amount due for the selected order. To display the calculated values in
        the footer controls, ItemDataBound event is used 
        <li>The DtAdapNewItems component in this page uses a database
        view created dynamically using CreateNewItemsView in <a href="#global">Global.pas</a>.
        This view is created by selecting columns from PARTS, ORDERS and ITEMS
        table in dbdemos database. This view is destroyed when the session ends
        (See Session_End procedure in <a href="#global">Global.pas</a>) 
        </li>
      </ul>
      <p>Source code for this page can be found in:</p>
      <ul>
        <li>UpdateItems.pas 
        <li>UpdateItems.aspx </li>
      </ul>
      <p>&nbsp;</p>
      <h3 id="querycustomer">Query Customer</h3>
      <p>This page is used to enter a narrower range of dates against
      which to check for customer invoices in <a href="#browseorders">Browse
        Orders</a> page. Once this query is defined, it can be activated
      from <a href="#browseorders">Browse Orders</a>
       page to limit the number of customer invoice records displayed in
      the customer grid. 
      </p>
      <p>This page demonstrates how to use Cache to store start and end
      dates entered either by selecting a date from the Calendar controls or by
      typing the desired date values&nbsp;in the text box controls. It also
      shows how you can use a CompareValidator to compare dates.</p>
      <p>Source code for this page can be found in:</p>
      <ul>
        <li>QueryCustomer.pas 
        <li>QueryCustomer.aspx </li>
      </ul>
      <p>&nbsp;</p>
      <h3 id="mastapphelp">MastApp Help</h3>
      <p>This is the help page that has information about the various
      features demonstrated in this MastApp demo. This page has only static help
      contents in MastAppHelp.aspx file.</p>
      <p>Source code for this page can be found in:</p>
      <ul>
        <li>MastAppHelp.aspx 
        <li>MastAppHelp.pas </li>
      </ul>
      <p>&nbsp;</p>
      <h3 id="mastappcss">MastApp StyleSheet</h3>
      <p>This stylesheet (mastapp.css) is used for the background color
      and font settings for all pages. You can use your custom stylesheet for
      this demo by just changing the following line in the header of all .aspx
      pages.</p>
      <p>&lt;link href="mastapp.css" type="text/css"
	  rel="stylesheet"&gt;</p>
	  <p>&nbsp;</p>
      <h3 id="global">Global.pas</h3>
      <p>This page has two methods : CreateNewItemsView and
      ExecuteCommand. CreateNewItemsView is used to create a new view (named NEW
      ITEMS) in dbdemos database. ExecuteCommand is used&nbsp;to execute any SQL
      command that is passed as an argument. The database view is created when
      the session starts (Session_Start) and dropped when the session ends
      (Session_End).</p>
      <p>Source code for this can be found in:</p>
      <ul>
        <li>Global.pas 
        <li>Global.asax </li>
      </ul>
    </form>
  </body>
</html>
